﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Threading;
using System.IO;

using QCAP.NET.X64;

namespace FilePlayback
{
    public unsafe partial class Form1 : Form
    {       
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);             

        public string m_pszFileSourceName;              // FILE SORCE NAME

        public ulong m_pFile = 0;                        // FILE SOURCE DEVICE       

        public bool FileUnInitialize()
        {       
            if (m_pFile != 0)
            {
                EXPORTS.QCAP_DESTROY_FILE(m_pFile);

                m_pFile = 0;
            }
          
            m_editWidth.Text = "";            

            m_editHeight.Text = "";

            m_editVideoFrame.Text = "";

            m_editVideoFrame.Text = "";

            m_editDurations.Text = "";

            m_editAudioFormat.Text = "";

            m_editAudioChannel.Text = "";

            m_editAudioFrame.Text = "";

            m_editAudioBitsPerSample.Text = "";

            m_editAudioSamplesPerSec.Text = "";          

            m_editAudioFormat.Text = "";

            m_editFrameRate.Text = "";

            return true;
        }

        public bool FileInitialize()
        {
            FileUnInitialize();

            uint nDecodeType = (uint)EXPORTS.DecoderTypeEnum.QCAP_DECODER_TYPE_SOFTWARE; 

            uint nVideoFormat = 1;

            uint nVideoWidth =200;

            uint nVideoHeight = 200;

            double dVideoFrameRate = 10.0;

            uint nAudioFormat = 1;

            uint nAudioChannels = 1;

            uint nAudioBitsPerSample = 1;

            uint nAudioSampleFrequency = 1;

            double nTotalDurationTimes = 1;

            uint nTotalVideoFrames = 1;

            uint nTotalAudioFrames = 1;

            uint nTotalMetadataFrames = 1;

            ulong hAttachedWindow = (ulong)(panel1.Handle.ToInt64());

            string strFileName = m_pszFileSourceName;

            string str_null = null;

            EXPORTS.QCAP_SET_SYSTEM_CONFIGURATION(1, 1, 1, 1, 1, 3000, 0, ref str_null, 0, 1, 0, 1, 1, ref str_null, ref str_null);

            EXPORTS.ResultOfFunction resultMsg = EXPORTS.QCAP_OPEN_FILE(  ref strFileName,
                                                                          ref m_pFile,
                                                                              nDecodeType,
                                                                          ref nVideoFormat, 
                                                                          ref nVideoWidth,
                                                                          ref nVideoHeight, 
                                                                          ref dVideoFrameRate, 
                                                                          ref nAudioFormat, 
                                                                          ref nAudioChannels, 
                                                                          ref nAudioBitsPerSample,
                                                                          ref nAudioSampleFrequency, 
                                                                          ref nTotalDurationTimes, 
                                                                          ref nTotalVideoFrames, 
                                                                          ref nTotalAudioFrames,
                                                                          ref nTotalMetadataFrames,
                                                                              hAttachedWindow, 
                                                                              1, 
                                                                              1);


            m_editWidth.Text = nVideoWidth.ToString();

            m_editHeight.Text = nVideoHeight.ToString();

            m_editFrameRate.Text = dVideoFrameRate.ToString();

            if (nAudioFormat == (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM )
            {
                m_editAudioFormat.Text = "PCM";
            }
            
            if (nAudioFormat == (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC_RAW || 
                nAudioFormat == (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC)
            {
                m_editAudioFormat.Text = "AAC";
            }

            if (nAudioFormat == (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC_ADTS )
            {
                m_editAudioFormat.Text = "AAC ADTS";
            }
            
            m_editAudioChannel.Text = nAudioChannels.ToString();
            
            m_editAudioBitsPerSample.Text = nAudioBitsPerSample.ToString();

            m_editAudioSamplesPerSec.Text = nAudioSampleFrequency.ToString();

            m_editVideoFrame.Text = nTotalVideoFrames.ToString();

            m_editAudioFrame.Text = nTotalAudioFrames.ToString();

            m_editDurations.Text = nTotalDurationTimes.ToString();
          
            return true;
        }
        
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {            
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            FileUnInitialize();            
        }

        private void mbtnBrowseAVIFile_Click(object sender, EventArgs e)
        {            
            OpenFileDialog dialog = new OpenFileDialog();

            dialog.Filter = "MP4 files (*.mp4)|*.mp4|All files (*.*)|*.*";

            dialog.InitialDirectory = Application.StartupPath;

            dialog.Title = "Select a mp4 file";

            if (dialog.ShowDialog() == DialogResult.OK)
            {
                m_editAviFilePath.Text = dialog.FileName;

                m_pszFileSourceName = m_editAviFilePath.Text;                

                FileInitialize();
            }            
        }

        private void btnRun_Click(object sender, EventArgs e)
        {
            if (m_pFile != 0)
            {
                EXPORTS.QCAP_PLAY_FILE(m_pFile);
            }
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            if (m_pFile != 0)
            {
                EXPORTS.QCAP_STOP_FILE(m_pFile);
            }
        }

        private void btnPause_Click(object sender, EventArgs e)
        {
            if (m_pFile != 0)
            {
                EXPORTS.QCAP_PAUSE_FILE(m_pFile);
            }
        }          

        private void btnNormalSpeed_Click(object sender, EventArgs e)
        {
            if (m_pFile != 0)
            {
                EXPORTS.QCAP_SET_FILE_PLAYBACK_SPEED(m_pFile, 1.0);
            }
        }

        private void btnTwoSpeed_Click(object sender, EventArgs e)
        {
            if (m_pFile != 0)
            {
                EXPORTS.QCAP_SET_FILE_PLAYBACK_SPEED(m_pFile, 2.0);
            }
        }

        private void btnQuadSpeed_Click(object sender, EventArgs e)
        {
            if (m_pFile != 0)
            {
                EXPORTS.QCAP_SET_FILE_PLAYBACK_SPEED(m_pFile, 4.0);
            }
        }       
    }
}